hingeToHingeSpacing = 40.215;
boltHoleRadius = 2;
servoScrewHoleRadius = 0.75;
thickness = 3;
servoRotorToMountingHole = 8.4;
overallLength = 23.4 + hingeToHingeSpacing;

use <Templates\servoFootprints.scad>
use <Templates/servoFootprints.scad>
$fn = 600;

translate([0,26,0]){
    difference(){
        translate([0,0,0]){
            cube([overallLength,24,thickness], center  = true);
        }
        translate([-overallLength/2 + thickness,6,0]){
            sg90Footprint(thickness * 2);
        }
        translate([-overallLength/2 + thickness*2,-6,0]){
            boltHole();
        }
        translate([overallLength/2 - thickness*2,-6,0]){
            boltHole();
        }
        translate([overallLength/2 - thickness*6,-6,0]){
            boltHole();
        }
    }
}

difference(){
    translate([0,0,0]){
        cube([overallLength,24,thickness], center  = true);
    }
    translate([-overallLength/2 + thickness,6,0]){
        sg90Footprint(thickness * 2);
    }
    translate([-overallLength/2 + thickness*2,-6,0]){
        boltHole();
    }
    translate([overallLength/2 - thickness*2,-6,0]){
        boltHole();
    }
    translate([overallLength/2 - thickness*6,-6,0]){
        boltHole();
    }
}

translate([overallLength/3,-26,0]){
    difference(){
        cube([24, 24, thickness], center = true);
        translate([thickness*2,-6,0]){
            boltHole();
        }
        translate([-thickness*2,-6,0]){
            boltHole();
        }
        translate([0,6,0]){
            boltHole();
        }
    }
}

translate([-overallLength/3,-26,0]){
    difference(){
        cube([24, 24, thickness], center = true);
        translate([thickness*2,-6,0]){
            boltHole();
        }
        translate([-thickness*2,-6,0]){
            boltHole();
        }
        translate([0,6,0]){
            boltHole();
        }
    }
}


module boltHole(){
    cylinder(thickness + 1, boltHoleRadius, boltHoleRadius, center = true);
}